// (C)1997 Christian Janoff
// FILE.CC

#include <fstream.h>
#include "file.h"
#include "c1541.h"
#include "error.h"

void c1541disk::iofile_open(char *iofilename, int mode)
{
  char c='x';
  int mode2 = mode | ios::noreplace;

  if (option_verbose)
    {
      if (mode==WRITE) cout << "Writing ";
        else           cout << "Reading ";
      cout << "File " << iofilename << "." << endl;
    }

  if (mode==WRITE)
    {
      io.open(iofilename,mode2);
      if (!io)
	{
	  if (option_yes) c='y';

	  while (c!='y' && c!='Y' && c!='n' && c!='N')
	    {
	      cout << "File " << iofilename << " exists. Replace it?";
	      cin  >> c;
	    }
	  if (c=='y' || c=='Y')
	    {
	      io.open(iofilename,mode);
	      if (!io) file_error(1);
	    }
	  else file_error(3);
	}
    }
  else // mode==READ
    {
      io.open(iofilename,mode);
      if (!io) file_error(1);
    }
}

void c1541disk::iofile_close(void)
{
 io.close();
}

int c1541disk::iofile_get_byte(void)
{
 int c;

 c=io.get();
 if (c==EOF) file_error(2);

 return c;
}

void c1541disk::iofile_put_byte(int value)
{
 io.put((char)value);
}

void c1541disk::iofile_skip_bytes(int count)
{
 int i,c;

 for(i=0;i<count;i++)
   c=iofile_get_byte();
}
